Ext.data.JsonP.sol_common_AclUtils({"tagname":"class","name":"sol.common.AclUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.AclUtils.js","href":"lib_sol.common.AclUtils.html#sol-common-AclUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.06.000"],"elojc":true,"eloas":true,"eloix":true,"requires":["sol.common.JsonUtils","sol.common.ObjectFormatter","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.UserUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"accessCodes","tagname":"property","owner":"sol.common.AclUtils","id":"property-accessCodes","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"sordZ","tagname":"property","owner":"sol.common.AclUtils","id":"property-sordZ","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-addRights","meta":{}},{"name":"addSordRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-addSordRights","meta":{"private":true}},{"name":"appendAndGroupAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-appendAndGroupAcl","meta":{"private":true}},{"name":"appendInheritedAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-appendInheritedAcl","meta":{"private":true}},{"name":"appendUserAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-appendUserAcl","meta":{"private":true}},{"name":"canExecute","tagname":"method","owner":"sol.common.AclUtils","id":"method-canExecute","meta":{"private":true}},{"name":"changeRightsInBackground","tagname":"method","owner":"sol.common.AclUtils","id":"method-changeRightsInBackground","meta":{}},{"name":"checkPreconditions","tagname":"method","owner":"sol.common.AclUtils","id":"method-checkPreconditions","meta":{"private":true}},{"name":"containsRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-containsRights","meta":{}},{"name":"containsSessionUserAndhasEffectiveRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-containsSessionUserAndhasEffectiveRights","meta":{}},{"name":"createAccessCode","tagname":"method","owner":"sol.common.AclUtils","id":"method-createAccessCode","meta":{"private":true}},{"name":"createAclItemFromAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-createAclItemFromAcl","meta":{"private":true}},{"name":"createAclItemFromUserInfo","tagname":"method","owner":"sol.common.AclUtils","id":"method-createAclItemFromUserInfo","meta":{"private":true}},{"name":"editRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-editRights","meta":{"private":true}},{"name":"editSordRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-editSordRights","meta":{"private":true}},{"name":"enrichContextSord","tagname":"method","owner":"sol.common.AclUtils","id":"method-enrichContextSord","meta":{"private":true}},{"name":"executeBackgroundAclJob","tagname":"method","owner":"sol.common.AclUtils","id":"method-executeBackgroundAclJob","meta":{"private":true}},{"name":"hasEffectiveRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-hasEffectiveRights","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"initializeRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-initializeRights","meta":{"private":true}},{"name":"ixExecutesBackgroundJobsSynchronous","tagname":"method","owner":"sol.common.AclUtils","id":"method-ixExecutesBackgroundJobsSynchronous","meta":{"private":true}},{"name":"preprocessUsers","tagname":"method","owner":"sol.common.AclUtils","id":"method-preprocessUsers","meta":{}},{"name":"removeRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-removeRights","meta":{}},{"name":"removeSordRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-removeSordRights","meta":{"private":true}},{"name":"replaceUserNamePlaceholders","tagname":"method","owner":"sol.common.AclUtils","id":"method-replaceUserNamePlaceholders","meta":{"private":true}},{"name":"restoreRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-restoreRights","meta":{}},{"name":"restoreSordRights","tagname":"method","owner":"sol.common.AclUtils","id":"method-restoreSordRights","meta":{"private":true}},{"name":"retrieveAndGroupAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-retrieveAndGroupAcl","meta":{"private":true}},{"name":"retrieveElements","tagname":"method","owner":"sol.common.AclUtils","id":"method-retrieveElements","meta":{"private":true}},{"name":"retrieveSordAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-retrieveSordAcl","meta":{"private":true}},{"name":"retrieveUserAcl","tagname":"method","owner":"sol.common.AclUtils","id":"method-retrieveUserAcl","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.AclUtils","short_doc":"Utility functions for ACL processing. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.AclUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils' target='_blank'>lib_sol.common.AclUtils.js</a></div></pre><div class='doc-contents'><p>Utility functions for ACL processing.</p>\n\n<p>The functions <code>addRights</code> and <code>removeRights</code> apply changes to an objects ACL items.\nThe <code>restore</code> function can restore the original rights if needed, and if there was a call to one of the before mentioned functions with a store command.</p>\n\n<h2>Function parameters</h2>\n\n<p>For examples see <a href=\"#!/api/sol.common.AclUtils-method-addRights\" rel=\"sol.common.AclUtils-method-addRights\" class=\"docClass\">addRights</a> and <a href=\"#!/api/sol.common.AclUtils-method-removeRights\" rel=\"sol.common.AclUtils-method-removeRights\" class=\"docClass\">removeRights</a></p>\n\n<h3>objId</h3>\n\n<p>ObjId of the Object which should be edited. If there is a <code>recursive</code> command (see config parameter) this is the starting point from which all sub-elements will ne processed.</p>\n\n<h3>users (only <code>addRights</code> and <code>removeRights</code>)</h3>\n\n<p>This is an Array with user names or user objects (or a mix of both).\nIf there are valid usernames specified, only those users ACL items will be altered.\nIf this contains objects they need to have a <code>name</code> property and may have an additional <code>rights</code> object. E.g.:</p>\n\n<pre><code>{\n  users: [\n    { name: \"AMustermann\", rights: { r: true, w: true } },\n    { name: \"BMustermann\", rights: { r: true, w: true, d: true } },\n    { name: \"CMustermann\" },   // will get the fallback access rights\n    \"DMustermann\"              // will get the fallback access rights\n  ]\n}\n</code></pre>\n\n<p>If this parameter is undefined or an empty Array, all existing ACL items will be adjusted.</p>\n\n<h3>rights (only <code>addRights</code> and <code>removeRights</code>)</h3>\n\n<p>This Object specifies, which rights should be added/removed.\nBoth following forms are valid:</p>\n\n<pre><code>{ r: true, w: true, d: false, e: false, l: false, p: false}\n{ read: false, write: true, del: true, edit: true, list: true. perm: true}\n</code></pre>\n\n<p>The <code>addRights</code> function will add all right, flaged with <code>true</code>, while <code>removeRights</code> will remove all rights flaged with <code>true</code>.</p>\n\n<h3>config</h3>\n\n<p>This Object contains additional processing information.\nCurrently the following parameters are supported:</p>\n\n<ul>\n<li>recursive: if <code>true</code>, all sub-elements will be processed</li>\n<li>storeAcl: Object which defines the store path: <code>{ type: \"MAP\", key: \"OLD_ACL\" }</code>. Currently only map fields are supported.</li>\n<li>asAdmin: if <code>true</code>, the rights will be altered in admin context.</li>\n</ul>\n\n\n<h2>Compatibility</h2>\n\n<p>All usage of the permission right ('p' or 'perm') is only supported in ELO12 and later.</p>\n      <p class='version-tag'>Version: <b>1.06.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-accessCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-property-accessCodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-property-accessCodes' class='name expandable'>accessCodes</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-sordZ' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-property-sordZ' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-property-sordZ' class='name expandable'>sordZ</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-addRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-addRights' class='name expandable'>addRights</a>( <span class='pre'>objId, users, rights, [config]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds rights to an archive entry/entries. ...</div><div class='long'><p>Adds rights to an archive entry/entries.</p>\n\n<p>The following example grants read, write and permission rights to the users \"baum\" and \"renz\" on exactly one object</p>\n\n<pre><code><a href=\"#!/api/sol.common.AclUtils-method-addRights\" rel=\"sol.common.AclUtils-method-addRights\" class=\"docClass\">sol.common.AclUtils.addRights</a>(\n  \"4711\",\n  [\"baum\", \"renz\"],\n  { r: true, w: true, d: false, e: false, l: false, p: true},\n  { }\n);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>The object which should be edited (if config has a <code>recursive</code> flag set to <code>true</code>, this object will be the starting point)</p>\n</div></li><li><span class='pre'>users</span> : String[]|Object[]<div class='sub-desc'><p>If this contains strings, they serve as user names. If it contains objects, they have to contain a <code>name</code> property and an <code>rights</code> object. If empty, all existing ACL entries will be edited.</p>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Object with flags for each right that should be added</p>\n</div></li><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'><p>Additional configuration parameters</p>\n<ul><li><span class='pre'>recursive</span> : Boolean (optional)<div class='sub-desc'><p>Process children or not</p>\n</div></li><li><span class='pre'>storeAcl</span> : Object (optional)<div class='sub-desc'><p>See example</p>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code> and admin context is available it will be used to perform the task</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-addSordRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-addSordRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-addSordRights' class='name expandable'>addSordRights</a>( <span class='pre'>oldAclList, newAclList, asAdmin</span> ) : de.elo.ix.client.AclItem[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldAclList</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>newAclList</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-appendAndGroupAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-appendAndGroupAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-appendAndGroupAcl' class='name expandable'>appendAndGroupAcl</a>( <span class='pre'>newAclItems, objId, config, defaultAccessCode</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Appends the and-group ACL items to the newAclItems array as configured. ...</div><div class='long'><p>Appends the and-group ACL items to the <code>newAclItems</code> array as configured.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newAclItems</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>defaultAccessCode</span> : Number<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-appendInheritedAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-appendInheritedAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-appendInheritedAcl' class='name expandable'>appendInheritedAcl</a>( <span class='pre'>newAclItems, objId, config, conn</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Appends the inherited ACL items to the newAclItems array as configured. ...</div><div class='long'><p>Appends the inherited ACL items to the <code>newAclItems</code> array as configured.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newAclItems</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-appendUserAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-appendUserAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-appendUserAcl' class='name expandable'>appendUserAcl</a>( <span class='pre'>newAclItems, objId, config, defaultAccessCode</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Appends the user ACL items to the newAclItems array as configured. ...</div><div class='long'><p>Appends the user ACL items to the <code>newAclItems</code> array as configured.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newAclItems</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>defaultAccessCode</span> : Number<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-canExecute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-canExecute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-canExecute' class='name expandable'>canExecute</a>( <span class='pre'>mode, aclItems</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if the background processing should be executed. ...</div><div class='long'><p>Checks, if the background processing should be executed.</p>\n\n<p>If mode is <code>SET</code> or <code>REPLACE</code> this always returns <code>true</code>, else it checks if there are acl items.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mode</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>aclItems</span> : Object[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-changeRightsInBackground' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-changeRightsInBackground' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-changeRightsInBackground' class='name expandable'>changeRightsInBackground</a>( <span class='pre'>objId, config</span> ) : de.elo.ix.client.JobState<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets or adds the rights by a background IX thread. ...</div><div class='long'><p>Sets or adds the rights by a background IX thread.</p>\n\n<p>Examples:</p>\n\n<pre><code>var jobState = <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">sol.common.AclUtils.changeRightsInBackground</a>(\"ARCPATH:/AclTest/Acl1\", { inherit: true, users: [\"weiler\", {name: \"zipfel\", rights:{r: true, w: true, p: true}}], rights: { r: true } });\nvar jobState = <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">sol.common.AclUtils.changeRightsInBackground</a>(\"ARCPATH:/AclTest/Acl1\", { mode: \"SET\", users: [\"zipfel\"], rights: { r: true } });\nvar jobState = <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">sol.common.AclUtils.changeRightsInBackground</a>(\"ARCPATH:/AclTest/Acl1\", { mode: \"SET\", users: [\"weiler\", { name: \"zipfel\", rights:{ r: true, w: true } }], rights: { r: true }, andGroups: { groups: [\"Pubsec.Registratur\", { name: \"Pubsec.Sachbearbeiter\" }], rights: { d: true } } });\nvar jobState = <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">sol.common.AclUtils.changeRightsInBackground</a>(\"ARCPATH:/AclTest/Acl1\", { mode: \"ADD\", users: [{ \"type\": \"GRP\", \"key\": \"CONTRACT_RESPONSIBLE\", \"rights\": { \"r\": true, \"w\": true, \"d\": false, \"e\": false, \"l\": false } }] });\n</code></pre>\n\n<p>Example with and-groups\n(sets an and-group with the groups 'GroupA', 'GroupB' and the group from the CONTRACT_RESPONSIBLE field with read only,\nas well as an and-group with the groups 'GroupX' and 'GroupY' with write access):</p>\n\n<pre><code>var jobState = <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">sol.common.AclUtils.changeRightsInBackground</a>(\"ARCPATH:/AclTest/Acl1\", {\n  mode: \"SET\",\n  andGroups: [\n    { groups: [\"GroupA\", \"GroupB\", { type: \"GRP\", key: \"CONTRACT_RESPONSIBLE\" }] },\n    { groups: [\"GroupX\", \"GroupY\"], rights: { r: true, w: true } }\n  ],\n  rights: { r: true } // default rights\n});\n</code></pre>\n\n<p>User or group names can be created using handlbars syntax (if the value will be read from an indexfield, that value could also contain handlebars syntax):</p>\n\n<pre><code>var jobState = <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">sol.common.AclUtils.changeRightsInBackground</a>(\"ARCPATH:/AclTest/Acl1\", {\n  mode: \"ADD\",\n  users: [\n    \"LEGAL_DEP_{{sord.objKeys.CONTRACT_DEPARTMENT}}\",\n    { name: \"CONTROLLING_{{sord.objKeys.CONTRACT_DEPARTMENT}}\", rights: { r: true, w: true } }\n  ],\n  rights: { r: true } // default rights\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String|String[]<div class='sub-desc'><p>Object ID of the object which will be changed or an array with start ids where each will be prosessed. If an array of ids is used, the parameter <code>config.srcObjId</code> is mandatory.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>mode</span> : String (optional)<div class='sub-desc'><p>\"ADD\", \"SET\" or \"REMOVE\" rights</p>\n<p>Defaults to: <code>&quot;ADD&quot;</code></p></div></li><li><span class='pre'>inherit</span> : Object<div class='sub-desc'><p>Inheritance configuration</p>\n<ul><li><span class='pre'>fromDirectParent</span> : Boolean<div class='sub-desc'><p>Inherit the ACL from the direct parent (default)</p>\n</div></li><li><span class='pre'>aclSrcObjId</span> : Boolean<div class='sub-desc'><p>Source object ID for the ACL inheritance</p>\n</div></li><li><span class='pre'>solutionObjectTypes</span> : String[]<div class='sub-desc'><p>Solution object types to find the ACL source object in the hierachy</p>\n</div></li></ul></div></li><li><span class='pre'>users</span> : String[]|Object[]<div class='sub-desc'><p>If this contains strings, they serve as user names. If it contains objects, they have to contain a <code>name</code> property and an <code>rights</code> object</p>\n</div></li><li><span class='pre'>andGroups</span> : Object[]<div class='sub-desc'><p>An array with and-group definitions</p>\n<ul><li><span class='pre'>groups</span> : String[]|Object[]<div class='sub-desc'><p>The groups contained in an and-group. Defined in the same way as <code>config.users</code> (but without the <code>rights</code> property).\nIf the <code>groups</code> array contains less than two entries the that and-group definition will be ignored.</p>\n</div></li><li><span class='pre'>rights</span> : Object[]<div class='sub-desc'><p>The rights of an and-group if deviant from fallback (<code>config.rights</code>)</p>\n</div></li></ul></div></li><li><span class='pre'>srcObjId</span> : String<div class='sub-desc'><p>If set, the user configurations will be read from this object instead of <code>objId</code>. Only mandatory if <code>objId</code> is an array.</p>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Additional rights, e.g. { read: false, write: true, del: true, edit: true, list: true, perm: true }</p>\n</div></li><li><span class='pre'>recursive</span> : Boolean (optional)<div class='sub-desc'><p>If true the ACL of the children will also be changed. Default is true.</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>dontWait</span> : Boolean (optional)<div class='sub-desc'><p>Don't wait for the background process. Default is false (synchronous).</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.JobState</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkPreconditions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-checkPreconditions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-checkPreconditions' class='name expandable'>checkPreconditions</a>( <span class='pre'>objId, config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks the preconditions and throws an exception if they are not meet. ...</div><div class='long'><p>Checks the preconditions and throws an exception if they are not meet.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String|String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-containsRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-containsRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-containsRights' class='name expandable'>containsRights</a>( <span class='pre'>accessCode, rights</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the access code contains the requested rights ...</div><div class='long'><p>Checks wether the access code contains the requested rights</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>accessCode</span> : Number<div class='sub-desc'><p>Access code</p>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Rights</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-containsSessionUserAndhasEffectiveRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-containsSessionUserAndhasEffectiveRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-containsSessionUserAndhasEffectiveRights' class='name expandable'>containsSessionUserAndhasEffectiveRights</a>( <span class='pre'>rightsConfig</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the users object contains the session user und the session user has already the effective rights ...</div><div class='long'><p>Checks wether the users object contains the session user und the session user has already the effective rights</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rightsConfig</span> : Object<div class='sub-desc'><p>Rights configuration</p>\n<ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Rights</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createAccessCode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-createAccessCode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-createAccessCode' class='name expandable'>createAccessCode</a>( <span class='pre'>rights</span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rights</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createAclItemFromAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-createAclItemFromAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-createAclItemFromAcl' class='name expandable'>createAclItemFromAcl</a>( <span class='pre'>aclItem, accessCode</span> ) : de.elo.ix.client.AclItem<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>aclItem</span> : de.elo.ix.client.AclItem<div class='sub-desc'>\n</div></li><li><span class='pre'>accessCode</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createAclItemFromUserInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-createAclItemFromUserInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-createAclItemFromUserInfo' class='name expandable'>createAclItemFromUserInfo</a>( <span class='pre'>userInfo, accessCode</span> ) : de.elo.ix.client.AclItem<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userInfo</span> : de.elo.ix.client.UserInfo<div class='sub-desc'>\n</div></li><li><span class='pre'>accessCode</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-editRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-editRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-editRights' class='name expandable'>editRights</a>( <span class='pre'>objId, users, rights, config, combineAclFunction</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>users</span> : Array<div class='sub-desc'>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>combineAclFunction</span> : Function<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-editSordRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-editSordRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-editSordRights' class='name expandable'>editSordRights</a>( <span class='pre'>sord, params</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord[]<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enrichContextSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-enrichContextSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-enrichContextSord' class='name expandable'>enrichContextSord</a>( <span class='pre'>ctxSord, inclTplSord, conn</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Prefills the context object with sord and if requested with a template sord. ...</div><div class='long'><p>Prefills the context object with sord and if requested with a template sord.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ctxSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>inclTplSord</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The ctxSord itself after enrichment</p>\n</div></li></ul></div></div></div><div id='method-executeBackgroundAclJob' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-executeBackgroundAclJob' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-executeBackgroundAclJob' class='name expandable'>executeBackgroundAclJob</a>( <span class='pre'>conn, startIds, config, newAclItems</span> ) : de.elo.ix.client.JobState<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Executes the background processing of the rights. ...</div><div class='long'><p>Executes the background processing of the rights.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'>\n</div></li><li><span class='pre'>startIds</span> : String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>newAclItems</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.JobState</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasEffectiveRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-hasEffectiveRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-hasEffectiveRights' class='name expandable'>hasEffectiveRights</a>( <span class='pre'>sord, params</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the current user has effective rights ...</div><div class='long'><p>Checks wether the current user has effective rights</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>Object ID or Sord</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Rights</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-initializeRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-initializeRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-initializeRights' class='name expandable'>initializeRights</a>( <span class='pre'>newAclItems, objId, config, conn</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks and initializes the rights config. ...</div><div class='long'><p>Checks and initializes the rights config.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newAclItems</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-ixExecutesBackgroundJobsSynchronous' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-ixExecutesBackgroundJobsSynchronous' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-ixExecutesBackgroundJobsSynchronous' class='name expandable'>ixExecutesBackgroundJobsSynchronous</a>( <span class='pre'>conn</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks if the IX version processes background jobs synchronous. ...</div><div class='long'><p>Checks if the IX version processes background jobs synchronous.\nThis is true for IX version higher than '9.18.060', '10.18.060' and '11.01.000'.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>The connection wich is used to determine the IX version.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-preprocessUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-preprocessUsers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-preprocessUsers' class='name expandable'>preprocessUsers</a>( <span class='pre'>objId, users</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Preprocesses users. ...</div><div class='long'><p>Preprocesses users.\nRetrieves user names from index fields.\nIf a user name or the retrieved value contains handlebars syntax, the sord will be applied to that string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>users</span> : String[]|Number[]|Object[]<div class='sub-desc'><p>Array of user defintions. all Types can be mixed.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'><h1>Example of the parameter 'users':</h1>\n\n<pre><code>[\n  \"mustermannm\",\n  23,\n  { \"type\": \"GRP\", \"key\": \"CONTRACT_RESPONSIBLE\", \"rights\": { \"r\": true, \"w\": true, \"d\": false, \"e\": false, \"l\": false, \"p\": true } },\n  { \"type\": \"GRP\", \"key\": \"CONTRACT_DEPARTMENT\", \"rights\": { \"r\": true, \"w\": true, \"d\": false, \"e\": false, \"l\": false, \"p\": true } },\n  { \"type\": \"GRP\", \"key\": \"CONTRACT_PROCUREMENT\", \"rights\": { \"r\": true, \"w\": true, \"d\": false, \"e\": false, \"l\": false, \"p\": false } },\n  { \"name\": \"LEGAL_DEP_{{sord.objKeys.CONTRACT_DEPARTMENT}}\", \"rights\": { \"r\": true, \"w\": false, \"d\": false, \"e\": false, \"l\": false, \"p\": false } }\n]\n</code></pre>\n</div></li></ul></div></div></div><div id='method-removeRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-removeRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-removeRights' class='name expandable'>removeRights</a>( <span class='pre'>objId, users, rights, [config]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes rights from an archive entry/entries. ...</div><div class='long'><p>Removes rights from an archive entry/entries.</p>\n\n<p>The following example will remove all rights (exept for read) for all users, having access to the object (and all sub-objects)\nand store the original right to an map field (OLC_ACL) for a later restore.</p>\n\n<pre><code><a href=\"#!/api/sol.common.AclUtils-method-removeRights\" rel=\"sol.common.AclUtils-method-removeRights\" class=\"docClass\">sol.common.AclUtils.removeRights</a>(\n  \"4711\",\n  [],\n  { read: false, write: true, del: true, edit: true, list: true, perm: true },\n  { recursive: true, storeAcl: { type: \"MAP\", key: \"OLD_ACL\" } }\n);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>The object which should be edited (if config has a <code>recursive</code> flag set to <code>true</code>, this object will be the starting point)</p>\n</div></li><li><span class='pre'>users</span> : String[]|Object[]<div class='sub-desc'><p>If this contains strings, they serve as user names. If it contains objects, they have to contain a <code>name</code> property and an <code>rights</code> object. If empty, all existing ACL entries will be edited.</p>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Object with flags for each right that should be removed</p>\n</div></li><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'><p>Additional configuration parameters</p>\n<ul><li><span class='pre'>recursive</span> : Boolean (optional)<div class='sub-desc'><p>Process children or not</p>\n</div></li><li><span class='pre'>storeAcl</span> : Object (optional)<div class='sub-desc'><p>See example</p>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code> and admin context is available it will be used to perform the task</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-removeSordRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-removeSordRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-removeSordRights' class='name expandable'>removeSordRights</a>( <span class='pre'>oldAclList, newAclList, asAdmin</span> ) : de.elo.ix.client.AclItem[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldAclList</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>newAclList</span> : de.elo.ix.client.AclItem[]<div class='sub-desc'>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-replaceUserNamePlaceholders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-replaceUserNamePlaceholders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-replaceUserNamePlaceholders' class='name expandable'>replaceUserNamePlaceholders</a>( <span class='pre'>userName, [ctxSord], [conn]</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Replace user name place holders:\n\n\nIf userName equals '$CURRENTUSER' the current session user will be used. ...</div><div class='long'><p>Replace user name place holders:</p>\n\n<ul>\n<li>If <code>userName</code> equals '$CURRENTUSER' the current session user will be used.</li>\n<li>If <code>username</code> contains handlebars syntax, the sord will be applied to it</li>\n</ul>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>ctxSord</span> : Object (optional)<div class='sub-desc'><p>only used if <code>userName</code> contains handlebars syntax</p>\n</div></li><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'><p>only used if <code>userName</code> contains handlebars syntax</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Username</p>\n</div></li></ul></div></div></div><div id='method-restoreRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-restoreRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-restoreRights' class='name expandable'>restoreRights</a>( <span class='pre'>objId, [config]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Restores (saved) rights for an archive entry/entries. ...</div><div class='long'><p>Restores (saved) rights for an archive entry/entries.</p>\n\n<p>The following example will restore all rights which where stored to the specified map field.</p>\n\n<pre><code><a href=\"#!/api/sol.common.AclUtils-method-restoreRights\" rel=\"sol.common.AclUtils-method-restoreRights\" class=\"docClass\">sol.common.AclUtils.restoreRights</a>(\n  \"4711\",\n  { recursive: true, storeAcl: { type: \"MAP\", key: \"OLD_ACL\" } }\n);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>The object which should be edited (if config has a <code>recursive</code> flag set to <code>true</code>, this object will be the starting point)</p>\n</div></li><li><span class='pre'>config</span> : Object (optional)<div class='sub-desc'><p>Additional configuration parameters</p>\n<ul><li><span class='pre'>recursive</span> : Boolean (optional)<div class='sub-desc'><p>Process children or not</p>\n</div></li><li><span class='pre'>storeAcl</span> : Object (optional)<div class='sub-desc'><p>See example</p>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code> and admin context is available it will be used to perform the task</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-restoreSordRights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-restoreSordRights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-restoreSordRights' class='name expandable'>restoreSordRights</a>( <span class='pre'>sord, params</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveAndGroupAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-retrieveAndGroupAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-retrieveAndGroupAcl' class='name expandable'>retrieveAndGroupAcl</a>( <span class='pre'>andGroup, defaultAccessCode, asAdmin</span> ) : de.elo.ix.client.AclItem<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>andGroup</span> : Object<div class='sub-desc'><p>An and-group definition (see <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a>)</p>\n</div></li><li><span class='pre'>defaultAccessCode</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveElements' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-retrieveElements' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-retrieveElements' class='name expandable'>retrieveElements</a>( <span class='pre'>objId, recursive, asAdmin</span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>recursive</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveSordAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-retrieveSordAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-retrieveSordAcl' class='name expandable'>retrieveSordAcl</a>( <span class='pre'>sord, accessCode</span> ) : de.elo.ix.client.AclItem[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li><li><span class='pre'>accessCode</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-retrieveUserAcl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.AclUtils'>sol.common.AclUtils</span><br/><a href='source/lib_sol.common.AclUtils.html#sol-common-AclUtils-method-retrieveUserAcl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.AclUtils-method-retrieveUserAcl' class='name expandable'>retrieveUserAcl</a>( <span class='pre'>users, accessCode, asAdmin</span> ) : de.elo.ix.client.AclItem[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>users</span> : String[]|Object[]<div class='sub-desc'><p>If this contains strings, they serve as user names. If it contains objects, they have to contain a <code>name</code> property and an <code>rights</code> object</p>\n</div></li><li><span class='pre'>accessCode</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.AclItem[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});